# Description

Files:
1. CAStLE_straightbore_cornercrack_tension.onnx: ONNX model of the CAStLE straight-bore single
   corner crack K_I,tension data
2. CAStLE_ONNX_example.py: Python code to load and run the CAStLE_straightbore_cornercrack_tension
   ONNX model

CAStLE_ONNX_example.py contains a castle_onnx_model class definition which contains code to load
the ONNX model and import the model metadata.  Metadata includes input map, reference dimension,
and model limits. Class methods take model parameter inputs as Python kwargs, process the
parameters into the W/R, A/C, A/T, and R/T format expected by the ONNX model, and scale the output
values as needed due to the difference between the given inputs and the model reference dimension.
See code comments for more details.

A short example at the end of CAStLE_ONNX_example.py shows how to use the castle_onnx_model class,
including creating input data, checking that the input parameters are within model limits, and 
calculating SIF values.

The example requires numpy and onnxruntime Python modules, and will generate a CSV file with Phi,
SIF, and K_I_tension columns. To install missing modules run the following commands from a Command
Prompt or PowerShell window:
    pip install numpy
    pip install onnxruntime

If the matplotlib module is installed, the code will produce PDF plot of K_I,tension vs Phi. 

To run example, save the CAStLE_straightbore_cornercrack_tension.onnx and CAStLE_ONNX_example.py
into the same directory, open a Command Prompt or PowerShell window enter the following command:
    python .\CAStLE_ONNX_example.py
